import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Divide the input grid into 4 4x4 matrices
    a = input_grid[:4, :4]
    b = input_grid[:4, 4:]
    c = input_grid[4:, :4]
    d = input_grid[4:, 4:]
    
    # Create a 4x4 matrix of black
    out = np.full((4, 4), black)
    
    # Replace the corresponding position pixels with the specified colors
    for i in range(4):
        for j in range(4):
            if a[i][j] == yellow:
                out[i][j] = yellow
            if d[i][j] == maroon:
                out[i][j] = maroon
            if c[i][j] == pink:
                out[i][j] = pink
            if b[i][j] == grey:
                out[i][j] = grey
    
    return out
    