import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Create an empty output grid
    output_grid = np.zeros((4, 4), dtype=int)
    
    # Add the upper 4x4 of the input grid with the bottom 4x4
    for i in range(4):
        for j in range(4):
            output_grid[i][j] = input_grid[i][j] + input_grid[i+5][j]
    
    # Check all points and update the color accordingly
    for i in range(4):
        for j in range(4):
            if output_grid[i][j] == blue or output_grid[i][j] == red:
                output_grid[i][j] = green
            elif output_grid[i][j] != blue and output_grid[i][j] != red:
                output_grid[i][j] = black
    
    return output_grid