import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    output_grid = np.copy(input_grid)
    rows, cols = input_grid.shape
    
    for i in range(rows):
        for j in range(cols):
            if input_grid[i][j] == red:
                if j+1 < cols and input_grid[i][j+1] == green:
                    output_grid[i][j] = black
                    output_grid[i][j+1] = teal
                elif i+1 < rows and input_grid[i+1][j] == green:
                    output_grid[i][j] = black
                    output_grid[i+1][j] = teal
                elif j-1 >= 0 and input_grid[i][j-1] == green:
                    output_grid[i][j] = black
                    output_grid[i][j-1] = teal
                elif i-1 >= 0 and input_grid[i-1][j] == green:
                    output_grid[i][j] = black
                    output_grid[i-1][j] = teal
            elif input_grid[i][j] == green:
                if j+1 < cols and input_grid[i][j+1] == red:
                    output_grid[i][j] = teal
                    output_grid[i][j+1] = black
                elif i+1 < rows and input_grid[i+1][j] == red:
                    output_grid[i][j] = teal
                    output_grid[i+1][j] = black
                elif j-1 >= 0 and input_grid[i][j-1] == red:
                    output_grid[i][j] = teal
                    output_grid[i][j-1] = black
                elif i-1 >= 0 and input_grid[i-1][j] == red:
                    output_grid[i][j] = teal
                    output_grid[i-1][j] = black
    
    return output_grid