import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    output_grid = np.copy(input_grid)
    rows, cols = input_grid.shape
    blue_row, blue_col = rows-1, 0
    
    while blue_row > 0:
        # Copy blue pixel right-up until reach right grid boundary
        while blue_col < cols-1:
            output_grid[blue_row, blue_col] = blue
            blue_row -= 1
            blue_col += 1
            if blue_row == 0:
                break
        if blue_row == 0:
            output_grid[0, blue_col] = blue
            break
        
        # Copy blue pixel left-up until reach left grid boundary
        while blue_col >= 0:
            output_grid[blue_row, blue_col] = blue
            blue_row -= 1
            blue_col -= 1
            if blue_col == 0:
                break
    
    # Fill remaining grid with blue and teal
    output_grid[output_grid == black] = teal
    
    return output_grid