import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Create a copy of the input grid to store the output
    output_grid = np.copy(input_grid)
    
    # Define a function to perform floodfill algorithm
    def floodfill(x, y, color):
        # Check if the current point is within the grid and is black
        if x < 0 or x >= len(input_grid) or y < 0 or y >= len(input_grid[0]) or input_grid[x][y] != black:
            return 0
        
        # Mark the current point as visited
        input_grid[x][y] = color
        
        # Recursively perform floodfill on neighboring points
        count = 1
        count += floodfill(x+1, y, color)
        count += floodfill(x-1, y, color)
        count += floodfill(x, y+1, color)
        count += floodfill(x, y-1, color)
        
        return count
    
    # Define a function to color the area based on the number of black points
    def color_floodfill(x, y, color):
        # Check if the current point is within the grid and is yellow
        if x < 0 or x >= len(input_grid) or y < 0 or y >= len(input_grid[0]) or input_grid[x][y] != yellow:
            return
        
        # Mark the current point as visited
        input_grid[x][y] = color
        
        # Recursively perform floodfill on neighboring points
        color_floodfill(x+1, y, color)
        color_floodfill(x-1, y, color)
        color_floodfill(x, y+1, color)
        color_floodfill(x, y-1, color)
    
    # Loop through each point in the input grid
    for i in range(len(input_grid)):
        for j in range(len(input_grid[0])):
            # If the point is black, perform floodfill algorithm
            if input_grid[i][j] == black:
                count = floodfill(i, j, yellow)
                
                # Color the area based on the number of black points
                if count == 1:
                    color_floodfill(i, j, green)
                elif count == 2:
                    color_floodfill(i, j, red)
                elif count == 3:
                    color_floodfill(i, j, blue)
    
    # Copy the colored input grid to the output grid
    output_grid = np.copy(input_grid)
    
    return output_grid