import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Create output grid
    output_grid = np.zeros((9, 3), dtype=int)

    # Copy input to output in top six rows
    output_grid[:6, :] = input_grid

    # Symmetrical left and right for input
    sym_input = np.fliplr(input_grid)

    # Copy top 3 rows of sym_input to output in bottom 3 rows
    output_grid[6:, :] = sym_input[:3, :]

    # Turn blue to red
    output_grid[output_grid == blue] = red

    return output_grid

