import numpy as np

# Define color codes
black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Find teal lines
    h_lines = np.where(np.all(input_grid == teal, axis=1))[0]
    v_lines = np.where(np.all(input_grid == teal, axis=0))[0]
    h_line1, h_line2 = h_lines[0], h_lines[-1]
    v_line1, v_line2 = v_lines[0], v_lines[-1]

    # Color rectangles
    input_grid[0:h_line1, 0:v_line1] = black
    input_grid[0:h_line1, v_line2+1:-1] = black
    input_grid[h_line2+1:, 0:v_line1] = black
    input_grid[h_line2+1:, v_line2+1:] = black
    input_grid[0:h_line1, v_line1+1:v_line2] = red
    input_grid[h_line1+1:h_line2, 0:v_line1] = yellow
    input_grid[h_line1+1:h_line2, v_line1+1:v_line2] = pink
    input_grid[h_line1+1:h_line2, v_line2+1:] = green
    input_grid[h_line2+1:, v_line1+1:v_line2] = blue

    return input_grid


