import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Define function to find connected domains
    def find_domains(grid):
        domains = []
        visited = np.zeros_like(grid)
        for i in range(grid.shape[0]):
            for j in range(grid.shape[1]):
                if grid[i][j] != black and visited[i][j] == 0:
                    domain = []
                    stack = [(i,j)]
                    while stack:
                        x,y = stack.pop()
                        if visited[x][y] == 0:
                            visited[x][y] = 1
                            domain.append((x,y))
                            if x > 0 and grid[x-1][y] == grid[x][y]:
                                stack.append((x-1,y))
                            if x < grid.shape[0]-1 and grid[x+1][y] == grid[x][y]:
                                stack.append((x+1,y))
                            if y > 0 and grid[x][y-1] == grid[x][y]:
                                stack.append((x,y-1))
                            if y < grid.shape[1]-1 and grid[x][y+1] == grid[x][y]:
                                stack.append((x,y+1))
                            if x > 0 and y > 0 and grid[x-1][y-1] == grid[x][y]:
                                stack.append((x-1,y-1))
                            if x > 0 and y < grid.shape[1]-1 and grid[x-1][y+1] == grid[x][y]:
                                stack.append((x-1,y+1))
                            if x < grid.shape[0]-1 and y > 0 and grid[x+1][y-1] == grid[x][y]:
                                stack.append((x+1,y-1))
                            if x < grid.shape[0]-1 and y < grid.shape[1]-1 and grid[x+1][y+1] == grid[x][y]:
                                stack.append((x+1,y+1))
                    domains.append(domain)
        return domains

    # Find connected domains
    domains = find_domains(input_grid)

    # Find teal domains
    teal_domains = []
    for domain in domains:
        if input_grid[domain[0]] == teal:
            teal_domains.append(domain)

    # Find minimum area domain
    min_area = float('inf')
    min_domain = None
    for domain in teal_domains:
        area = len(domain)
        if area < min_area:
            min_area = area
            min_domain = domain

    # Color domains
    output_grid = np.zeros_like(input_grid)
    for domain in teal_domains:
        if domain == min_domain:
            color = red
        else:
            color = blue
        for x,y in domain:
            output_grid[x][y] = color

    return output_grid