import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Get the number of rows and columns in the input grid
    num_rows, num_cols = input_grid.shape

    # Create a new output grid with the same values as the input grid
    output_grid = np.copy(input_grid)

    # Get the colors in the first row of the input grid
    colors = np.tile(input_grid[0], 2)

    # Color the lines from the 3rd to the last one with the colors in the first row
    for i in range(2, num_rows):
        output_grid[i] = colors[(i-2) % len(colors)]

    return output_grid