import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Define the left and right 3x3 grids
    left_grid = input_grid[:, :3]
    right_grid = input_grid[:, 4:]

    # Replace all blue pixels with red in both grids
    left_grid[left_grid == blue] = red
    right_grid[right_grid == blue] = red

    # Find the intersection of the left and right grids
    intersection = np.intersect1d(left_grid, right_grid)

    # Create an output grid with all black pixels
    output_grid = np.full((3, 3), black)

    # Paint the output grid red if the corresponding pixels in the left and right grids are both red
    for i in range(3):
        for j in range(3):
            if left_grid[i][j] == red and right_grid[i][j] == red:
                output_grid[i][j] = red

    return output_grid