import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Find the position of the green corner
    green_corner = None
    for i in range(2):
        for j in range(2):
            if input_grid[i*2][j*2] == green:
                green_corner = (i, j)
                break
        if green_corner:
            break
    
    # Create the output grid
    output_grid = np.full((9, 9), black)
    
    # Replace the appropriate sections with green
    if green_corner == (0, 0):
        output_grid[:4, :4] = green
        output_grid[4:8, 4:8] = green
    elif green_corner == (0, 1):
        output_grid[:4, 5:] = green
        output_grid[4:8, 1:5] = green
    elif green_corner == (1, 0):
        output_grid[5:, :4] = green
        output_grid[1:5, 4:8] = green
    elif green_corner == (1, 1):
        output_grid[5:, 5:] = green
        output_grid[1:5, 1:5] = green
    
    return output_grid
    