import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Create a copy of the input grid to modify
    output_grid = input_grid.copy()

    # Traverse all 2*2 sub-grids in the input grid
    for i in range(input_grid.shape[0]-1):
        for j in range(input_grid.shape[1]-1):
            subgrid = input_grid[i:i+2, j:j+2]

            # Check if there are three teal pixels and one black pixel in the sub-grid
            if np.sum(subgrid == teal) == 3 and np.sum(subgrid == black) == 1:
                # Paint the black pixel blue
                output_grid[i+np.where(subgrid == black)[0][0], j+np.where(subgrid == black)[1][0]] = blue

    return output_grid
    