import numpy as np
def main(input_grid):
    # Find the indices of non-black pixels
    non_black_indices = np.where(input_grid != 0)
    # Find the minimum and maximum indices of non-black pixels
    min_x, min_y = np.min(non_black_indices, axis=1)
    max_x, max_y = np.max(non_black_indices, axis=1)
    # Create a new grid with the minimum and maximum indices
    output_grid = input_grid[min_x:max_x+1, min_y:max_y+1]
    return output_grid