import numpy as np
black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)
def main(input_grid: np.ndarray) -> np.ndarray:
    # Find the smallest rectangle containing all non-black pixels
    non_black_pixels = np.where(input_grid != black)
    min_row, max_row = np.min(non_black_pixels[0]), np.max(non_black_pixels[0])
    min_col, max_col = np.min(non_black_pixels[1]), np.max(non_black_pixels[1])
    rect = input_grid[min_row:max_row+1, min_col:max_col+1]
    # Duplicate the rectangle in the right
    output_grid = np.concatenate((rect, rect), axis=1)
    return output_grid