import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    output_grid = np.copy(input_grid)
    rows, cols = input_grid.shape
    
    # Find all red points in input grid
    red_points = []
    for i in range(rows):
        for j in range(cols):
            if input_grid[i][j] == red:
                red_points.append((i,j))
    
    # Process each red point
    for i, j in red_points:
        # Check left point
        if j > 0 and input_grid[i][j-1] == black:
            len_green = 0
            for k in range(j+1, cols):
                if input_grid[i][k] == green:
                    len_green += 1
                elif input_grid[i][k] == black:
                    break
            output_grid[i-len_green:i+len_green+1, 0:j] = green
            output_grid[i, 0:j] = red
        
        # Check right point
        if j < cols-1 and input_grid[i][j+1] == black:
            len_green = 0
            for k in range(j-1, -1, -1):
                if input_grid[i][k] == green:
                    len_green += 1
                elif input_grid[i][k] == black:
                    break
            output_grid[i-len_green:i+len_green+1, j:cols] = green
            output_grid[i, j:cols] = red
        
        # Check up point
        if i > 0 and input_grid[i-1][j] == black:
            len_green = 0
            for k in range(i+1, rows):
                if input_grid[k][j] == green:
                    len_green += 1
                elif input_grid[k][j] == black:
                    break
            output_grid[0:i, j-len_green:j+len_green+1] = green
            output_grid[0:i, j] = red
        
        # Check down point
        if i < rows-1 and input_grid[i+1][j] == black:
            len_green = 0
            for k in range(i-1, -1, -1):
                if input_grid[k][j] == green:
                    len_green += 1
                elif input_grid[k][j] == black:
                    break
            output_grid[i:rows, j-len_green:j+len_green+1] = green
            output_grid[i, j:cols] = red
    
    return output_grid