import numpy as np

# Define color codes
black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Get the dimensions of the input grid
    rows, cols = input_grid.shape

    # Find the consecutive horizontal and vertical lines in black
    black_rows = np.where(np.all(input_grid == black, axis=1))[0]
    black_cols = np.where(np.all(input_grid == black, axis=0))[0]

    # Divide the input grid into four smaller grids
    top_left = input_grid[:black_rows[0], :black_cols[0]]
    top_right = input_grid[:black_rows[0], black_cols[-1]+1:]
    bottom_left = input_grid[black_rows[-1]+1:, :black_cols[0]]
    bottom_right = input_grid[black_rows[-1]+1:, black_cols[-1]+1:]

    # Find the two colors in each small grid
    top_left_colors = np.unique(top_left)
    top_right_colors = np.unique(top_right)
    bottom_left_colors = np.unique(bottom_left)
    bottom_right_colors = np.unique(bottom_right)

    # Find the different color in the small grids
    different_color = None
    for color in [blue, red, green, yellow, grey, pink, orange, teal, maroon]:
        if color != black:
            if color in top_left_colors and color not in top_right_colors and color not in bottom_left_colors and color not in bottom_right_colors:
                different_color = color
                different_grid = top_left
                break
            elif color in top_right_colors and color not in top_left_colors and color not in bottom_left_colors and color not in bottom_right_colors:
                different_color = color
                different_grid = top_right
                break
            elif color in bottom_left_colors and color not in top_left_colors and color not in top_right_colors and color not in bottom_right_colors:
                different_color = color
                different_grid = bottom_left
                break
            elif color in bottom_right_colors and color not in top_left_colors and color not in top_right_colors and color not in bottom_left_colors:
                different_color = color
                different_grid = bottom_right
                break

    # Create the output grid with the dimensions of the different small grid
    output_grid = np.zeros_like(different_grid)

    # Fill the output grid with the color of the different small grid
    output_grid[different_grid == different_color] = different_color

    return output_grid