import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Get the locations of all the teal pixels
    teal_pixels = np.argwhere(input_grid == teal)

    # Loop through all pairs of teal pixels
    for i in range(len(teal_pixels)):
        for j in range(i+1, len(teal_pixels)):
            # If the teal pixels are in the same row, change all pixels between them to green
            if teal_pixels[i][0] == teal_pixels[j][0]:
                row = teal_pixels[i][0]
                start_col = min(teal_pixels[i][1], teal_pixels[j][1])
                end_col = max(teal_pixels[i][1], teal_pixels[j][1])
                input_grid[row, start_col+1:end_col] = green
            # If the teal pixels are in the same column, change all pixels between them to green
            elif teal_pixels[i][1] == teal_pixels[j][1]:
                col = teal_pixels[i][1]
                start_row = min(teal_pixels[i][0], teal_pixels[j][0])
                end_row = max(teal_pixels[i][0], teal_pixels[j][0])
                input_grid[start_row+1:end_row, col] = green

    return input_grid