import numpy as np

# Define color codes
black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Initialize variables
    colors = []
    output_grid = None

    # Traverse the input grid
    for row in input_grid:
        for color in row:
            if color not in colors:
                colors.append(color)

    # Determine the shape of the output grid
    if len(colors) == 1:
        output_grid = np.array(colors).reshape(len(colors), 1)
    else:
        output_grid = np.array(colors).reshape(1, len(colors))

    return output_grid