import numpy as np

# Define color codes
(black, blue, red, green, yellow, grey, pink, orange, teal, maroon) = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Step 1: Obtain the height of the input image matrix
    d = input_grid.shape[0]

    # Step 2: Rotate the input image by 90, 180, and 270 degrees
    input_grid1 = np.rot90(input_grid, k=1)
    input_grid2 = np.rot90(input_grid, k=2)
    input_grid3 = np.rot90(input_grid, k=3)

    # Add the rotated images on top of the original input_grid
    input_grid = np.add(np.add(np.add(input_grid, input_grid1), input_grid2), input_grid3)

    # Step 3: Traverse from row 0 to row int(d/2)
    for i in range(int(d/2)):
        # Visit coordinate (i,i+2) and record its color as c
        c = input_grid[i, i+2]
        # Assign pixels with even distances to c
        for j in range(i+4, d, 2):
            if input_grid[i, j] == black:
                input_grid[i, j] = c
            else:
                break

    # Step 4: Traverse from row int(d/2) to row d
    for i in range(int(d/2), d):
        # Visit coordinate (i,i-2) and record its color as c
        c = input_grid[i, i-2]
        # Assign pixels with even distances to c
        for j in range(i-4, -1, -2):
            if input_grid[i, j] == black:
                input_grid[i, j] = c
            else:
                break

    # Step 5: Rotate the modified input_grid by 90 degrees
    input_grid4 = np.rot90(input_grid, k=1)
    # Create an all-black matrix output_grid of the same size as input_grid
    output_grid = np.zeros_like(input_grid)
    # Traverse each pixel in output_grid and assign its value to the corresponding value in input_grid
    for i in range(d):
        for j in range(d):
            if input_grid[i, j] != black:
                output_grid[i, j] = input_grid[i, j]
            else:
                output_grid[i, j] = input_grid4[i, j]

    # Step 6: Return the modified input_grid
    return output_grid
    