import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Find smallest matrix with all green pixels
    green_pixels = np.where(input_grid == green)
    min_row, max_row = np.min(green_pixels[0]), np.max(green_pixels[0])
    min_col, max_col = np.min(green_pixels[1]), np.max(green_pixels[1])
    m = input_grid[min_row:max_row+1, min_col:max_col+1]
    
    # Create output grid
    output = np.zeros_like(m)
    w = input_grid.shape[1]
    
    # Iterate over green pixels in m
    for r, c in zip(*np.where(m == green)):
        if min_row < w // 2 < max_row:
            output[r, c] = input_grid[w - min_row - r - 1, min_col + c]
        else:
            output[r, c] = input_grid[min_row + r, w - min_col - c - 1]
    
    return output