import numpy as np
black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)
def main(input_grid: np.ndarray) -> np.ndarray:
    # Get the number of rows and columns in the input grid
    num_rows, num_cols = input_grid.shape
    # Create a copy of the input grid to modify
    output_grid = input_grid.copy()
    # Loop through each cell in the input grid
    for row in range(num_rows):
        for col in range(num_cols):
            # If the current cell is black
            if input_grid[row, col] == black:
                # Get the color of the grid 9 cells below in the same column
                color_below = input_grid[(row + 9) % num_rows, col]
                # If the color below is not black, set the current cell to that color
                if color_below != black:
                    output_grid[row, col] = color_below
                else:
                    # Otherwise, get the color of the grid 18 cells below in the same column
                    color_below_18 = input_grid[(row + 18) % num_rows, col]
                    output_grid[row, col] = color_below_18
    return output_grid
