import numpy as np
black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)
def main(input_grid: np.ndarray) -> np.ndarray:
    # Find the first four rows that contain color other than black
    rows_to_move = []
    for i in range(input_grid.shape[0]):
        if np.any(input_grid[i] != black):
            rows_to_move.append(i)
        if len(rows_to_move) == 4:
            break
    # Move the first four rows to the right for one grid (except for the rightmost non-black grid)
    output_grid = np.zeros_like(input_grid)
    for i in range(input_grid.shape[0]):
        if i in rows_to_move[:4]:
            row = input_grid[i]
            if row[-1] != black:
                output_grid[i, 1:] = row[:-1]
                output_grid[i, -1] = row[-1]
            else:
                output_grid[i, 1:] = row[:-1]
        else:
            output_grid[i] = input_grid[i]
    return output_grid
