import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Define the teal rows and cols
    teal_rows = [3, 7]
    teal_cols = [3, 7]

    # Initialize the output grid
    output_grid = np.zeros((3, 3), dtype=int)

    # Loop through each 3x3 grid in the input grid
    for i in range(3):
        for j in range(3):
            # Get the 3x3 grid
            grid = input_grid[i*3+i:i*3+3+i, j*3+j:j*3+3+j]

            # Count the number of pink pixels in the grid
            pink_count = np.count_nonzero(grid == pink)

            # If there are two pink pixels, color the corresponding pixel in the output grid blue
            if pink_count == 2:
                output_grid[i, j] = blue

    return output_grid