import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Get the size of the input grid
    n = input_grid.shape[0]
    
    # Create a copy of the input grid to store the output
    output_grid = input_grid.copy()
    
    # Loop through each pixel in the input grid
    for i in range(n):
        for j in range(n):
            # Check if the pixel is on the secondary diagonal
            if i == j:
                # Check if the pixel is black
                if input_grid[i][j] == black:
                    # Find the first non-black pixel on the secondary diagonal
                    for k in range(n):
                        if input_grid[k][n-k-1] != black:
                            output_grid[i][j] = input_grid[k][n-k-1]
                            break
                else:
                    # Color the pixel to the color of the non-black pixel on the secondary diagonal
                    output_grid[i][j] = input_grid[i][j]
            else:
                # Check if the pixel is black
                if input_grid[i][j] == black:
                    # Find the symmetrical pixel
                    sym_i = j
                    sym_j = i
                    
                    # Check if the symmetrical pixel is not black
                    if input_grid[sym_i][sym_j] != black:
                        # Color the pixel to the color of the symmetrical pixel
                        output_grid[i][j] = input_grid[sym_i][sym_j]
                    else:
                        # Find the most neighbor pixel
                        neighbors = []
                        if i > 0 and input_grid[i-1][j] != black:
                            neighbors.append(input_grid[i-1][j])
                        if i < n-1 and input_grid[i+1][j] != black:
                            neighbors.append(input_grid[i+1][j])
                        if j > 0 and input_grid[i][j-1] != black:
                            neighbors.append(input_grid[i][j-1])
                        if j < n-1 and input_grid[i][j+1] != black:
                            neighbors.append(input_grid[i][j+1])
                        output_grid[i][j] = max(set(neighbors), key=neighbors.count)
                else:
                    # Color the pixel to the same color
                    output_grid[i][j] = input_grid[i][j]
    
    return output_grid