import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Create a copy of the input grid to modify
    output_grid = input_grid.copy()
    
    # Find all black pixels in the input grid
    black_pixels = np.argwhere(input_grid == black)
    
    # Loop through all black pixels and check if they are inside a red structure
    for i in range(len(black_pixels)):
        row = black_pixels[i][0]
        col = black_pixels[i][1]
        
        # Check left
        left = False
        for j in range(col-1, -1, -1):
            if input_grid[row][j] == red:
                left = True
                break
        
        # Check right
        right = False
        for j in range(col+1, input_grid.shape[1]):
            if input_grid[row][j] == red:
                right = True
                break
        
        # Check up
        up = False
        for j in range(row-1, -1, -1):
            if input_grid[j][col] == red:
                up = True
                break
        
        # Check down
        down = False
        for j in range(row+1, input_grid.shape[0]):
            if input_grid[j][col] == red:
                down = True
                break
        
        # If all sides have a red pixel, color the black pixel blue
        if left and right and up and down:
            output_grid[row][col] = blue
    
    return output_grid
    