import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    output_grid = np.zeros_like(input_grid) # create an empty output grid with the same size as the input grid
    
    # define a helper function to perform depth-first search
    def dfs(i, j, visited):
        visited.add((i, j)) # mark the current pixel as visited
        count = 1 # count the current pixel as part of the grey shape
        
        # check the adjacent pixels
        for di, dj in [(0, 1), (0, -1), (1, 0), (-1, 0)]:
            ni, nj = i + di, j + dj
            if ni >= 0 and ni < input_grid.shape[0] and nj >= 0 and nj < input_grid.shape[1] and input_grid[ni][nj] == grey and (ni, nj) not in visited:
                # if the adjacent pixel is grey and not visited, perform dfs on it
                subcount, visited = dfs(ni, nj, visited)
                count += subcount
        
        return count, visited
    
    # loop through each pixel in the input grid
    shapes = [] # initialize the list of shapes
    for i in range(input_grid.shape[0]):
        for j in range(input_grid.shape[1]):
            if input_grid[i][j] == grey and not any((i, j) in visited for visited, count in shapes): # if the pixel is grey and not part of a previously found grey shape
                # perform dfs to find the grey shape
                count, visited = dfs(i, j, set())
                shapes.append((tuple(visited), count)) # add the visited pixels and count to the list of shapes
    
    # loop through each grey shape and color it accordingly
    for visited, count in shapes:
        if count == 6: # if the grey shape has 6 pixels, color it red
            for i, j in visited:
                output_grid[i][j] = red
        else: # otherwise, color it blue
            for i, j in visited:
                output_grid[i][j] = blue
    
    return output_grid