import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Find the positions of the green and yellow pixels
    green_pos = np.argwhere(input_grid == green)[0]
    yellow_pos = np.argwhere(input_grid == yellow)[0]
    
    # Calculate the distance between the green and yellow pixels
    distance = np.abs(green_pos - yellow_pos)
    
    # Determine the direction to move the green pixel
    direction = np.sign(yellow_pos - green_pos)
    
    # Move the green pixel one block closer to the yellow pixel
    new_pos = green_pos + direction
    
    # Create the output grid with the same size as the input grid
    output_grid = np.zeros_like(input_grid)
    
    # Copy the input grid to the output grid
    output_grid[:] = input_grid[:]
    
    # Set the new position of the green pixel in the output grid
    output_grid[tuple(new_pos)] = green
    
    # Set the original position of the green pixel to black
    output_grid[tuple(green_pos)] = black
    
    return output_grid
