
import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Find the size of the pattern
    pattern_size = None
    for i in range(1, input_grid.shape[1]):
        if np.array_equal(input_grid[:, i], input_grid[:, 0]):
            pattern_size = i
            break
    print(pattern_size)
    # Extract the pattern
    pattern = input_grid[:, :pattern_size]
    
    # Create the output grid
    output_grid = np.zeros((pattern_size, pattern_size), dtype=int)
    
    # Paste the pattern into the output grid
    output_grid[:pattern.shape[0], :pattern.shape[1]] = pattern
    
    return output_grid