import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Find all the blue pixels in the grid
    blue_indices = np.where(input_grid == blue)
    
    # Color the downmost grey pixels that in the same column of the blue pixels to blue
    for i in range(len(blue_indices[0])):
        row = blue_indices[0][i]
        col = blue_indices[1][i]
        grey_index = np.where(input_grid[:, col] == grey)[0][-1]
        input_grid[grey_index][col] = blue
    
    # Color the origin blue pixels to black
    input_grid[blue_indices] = black
    
    return input_grid

