import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Find the coordinates of the not black pixel
    not_black_coords = np.argwhere(input_grid != black)[0]
    not_black_color = input_grid[not_black_coords[0], not_black_coords[1]]
    
    # Create a copy of the input grid to modify
    output_grid = input_grid.copy()
    
    # Color the diagonal lines of the not black pixel
    for i in range(-min(output_grid.shape), min(output_grid.shape)):
        if not_black_coords[0]+i >= 0 and not_black_coords[0]+i < output_grid.shape[0] and not_black_coords[1]+i >= 0 and not_black_coords[1]+i < output_grid.shape[1]:
            output_grid[not_black_coords[0]+i, not_black_coords[1]+i] = not_black_color
        if not_black_coords[0]-i >= 0 and not_black_coords[0]-i < output_grid.shape[0] and not_black_coords[1]+i >= 0 and not_black_coords[1]+i < output_grid.shape[1]:
            output_grid[not_black_coords[0]-i, not_black_coords[1]+i] = not_black_color
    
    return output_grid