import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Get the middle column of the input grid
    middle_column = input_grid[:, input_grid.shape[1] // 2]
    
    # Record the order of colors along the middle column
    color_order = []
    for color in middle_column:
        if color not in color_order:
            color_order.append(color)
    
    # Swap the colors of all pixels according to the order
    output_grid = np.copy(input_grid)
    for i in range(output_grid.shape[0]):
        for j in range(output_grid.shape[1]):
            color = output_grid[i, j]
            if color in color_order:
                new_color_index = color_order.index(color)
                new_color = color_order[-new_color_index - 1]
                output_grid[i, j] = new_color
    
    return output_grid