import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    ans_grid = np.copy(input_grid)
    rows, cols = ans_grid.shape

    # Step 1
    for i in range(rows):
        for j in range(cols):
            if ans_grid[i][j] == teal:
                pink_count = 0
                for x, y in [(i-1, j), (i+1, j), (i, j-1), (i, j+1)]:
                    if x >= 0 and x < rows and y >= 0 and y < cols and ans_grid[x][y] == pink:
                        pink_count += 1
                if pink_count == 1:
                    ans_grid[i][j] = green
                elif pink_count >= 2:
                    ans_grid[i][j] = yellow

    # Step 2
    for i in range(rows):
        for j in range(cols):
            if ans_grid[i][j] == teal:
                green_count = 0
                pink_count = 0
                for x, y in [(i-1, j-1), (i-1, j), (i-1, j+1), (i, j-1), (i, j+1), (i+1, j-1), (i+1, j), (i+1, j+1)]:
                    if x >= 0 and x < rows and y >= 0 and y < cols:
                        if ans_grid[x][y] == green:
                            green_count += 1
                        elif ans_grid[x][y] == pink:
                            pink_count += 1
                if green_count == 2 and pink_count == 1:
                    ans_grid[i][j] = green

    return ans_grid
    