import numpy as np
from typing import *

(black, blue, red, green, yellow, grey, pink, orange, teal, maroon) = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Find the top-left blue pixel and the bottom-right red pixel
    blue_corner = None
    red_corner = None
    for i in range(input_grid.shape[0]):
        for j in range(input_grid.shape[1]):
            if input_grid[i][j] == blue:
                blue_corner = (i, j)
            elif input_grid[i][j] == red:
                red_corner = (i, j)
    
    # Put blue pixels on diagonal to top-left from blue_corner
    for i in range(blue_corner[0], -1, -1):
        if blue_corner[1] - (blue_corner[0] - i) >= 0:
            input_grid[i][blue_corner[1] - (blue_corner[0] - i)] = blue
    
    # Put red pixels on diagonal to bottom-right from red_corner
    for i in range(red_corner[0], input_grid.shape[0]):
        if red_corner[1] + (i - red_corner[0]) < input_grid.shape[1]:
            input_grid[i][red_corner[1] + (i - red_corner[0])] = red
    
    return input_grid