import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Find the positions of the yellow and green pixels
    yellow_pos = np.argwhere(input_grid == yellow)[0]
    green_pos = np.argwhere(input_grid == green)[0]
    
    # Calculate the distance between the yellow and green pixels
    distance = np.abs(yellow_pos - green_pos)
    
    # Determine the direction to move the green pixel
    direction = np.sign(yellow_pos - green_pos)
    
    # Move the green pixel one step closer to the yellow pixel
    new_pos = green_pos + direction
    
    # If the new position is the same as the yellow position, swap the yellow and green pixels
    if np.array_equal(new_pos, yellow_pos):
        input_grid[yellow_pos[0], yellow_pos[1]] = green
        input_grid[green_pos[0], green_pos[1]] = yellow
    else:
        input_grid[new_pos[0], new_pos[1]] = green
        input_grid[green_pos[0], green_pos[1]] = black
    
    return input_grid