import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Find blue and yellow pixels
    blueloc = np.where(input_grid == blue)
    yellowloc = np.where(input_grid == yellow)
    
    # Fill 8 pixels around blueloc with yellow
    for i in range(blueloc[0].size):
        x = blueloc[0][i]
        y = blueloc[1][i]
        for j in range(-1, 2):
            for k in range(-1, 2):
                if (x+j >= 0 and x+j < input_grid.shape[0] and y+k >= 0 and y+k < input_grid.shape[1]):
                    if (input_grid[x+j][y+k] != blue):
                        input_grid[x+j][y+k] = yellow
    
    # Fill 8 pixels around yellowloc with blue
    for i in range(yellowloc[0].size):
        x = yellowloc[0][i]
        y = yellowloc[1][i]
        for j in range(-1, 2):
            for k in range(-1, 2):
                if (x+j >= 0 and x+j < input_grid.shape[0] and y+k >= 0 and y+k < input_grid.shape[1]):
                    if (input_grid[x+j][y+k] != yellow):
                        input_grid[x+j][y+k] = blue
    
    # Fill blueloc with blue
    for i in range(blueloc[0].size):
        x = blueloc[0][i]
        y = blueloc[1][i]
        input_grid[x][y] = blue
    
    # Fill yellowloc with yellow
    for i in range(yellowloc[0].size):
        x = yellowloc[0][i]
        y = yellowloc[1][i]
        input_grid[x][y] = yellow
    
    # Find left, right, up, down edge of blueloc
    left = np.min(blueloc[1])
    right = np.max(blueloc[1])
    up = np.min(blueloc[0])
    down = np.max(blueloc[0])
    
    # Fill pixels with grey
    input_grid[up+2][left] = grey
    input_grid[up+4][left] = grey
    input_grid[down-2][left] = grey
    input_grid[down-4][left] = grey
    input_grid[up+2][right] = grey
    input_grid[up+4][right] = grey
    input_grid[down-2][right] = grey
    input_grid[down-4][right] = grey
    input_grid[up][left+2] = grey
    input_grid[up][left+4] = grey
    input_grid[up][right-2] = grey
    input_grid[up][right-4] = grey
    input_grid[down][left+2] = grey
    input_grid[down][left+4] = grey
    input_grid[down][right-2] = grey
    input_grid[down][right-4] = grey
    
    return input_grid