import numpy as np
black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Find the index of the grey line
    grey_line_index = np.where(input_grid == grey)[0][0]
    
    # Split the input grid along the grey line
    sub_grid_1 = input_grid[:grey_line_index, :]
    sub_grid_2 = input_grid[grey_line_index+1:, :]
    
    # Copy sub_grid_1 to create a new grid
    new_grid = np.copy(sub_grid_1)
    
    # Copy non-black pixels from sub_grid_2 to new_grid
    non_black_pixels = np.where(sub_grid_2 != black)
    new_grid[non_black_pixels] = sub_grid_2[non_black_pixels]
    
    return new_grid