# install.packages('ggthemes', repos = "http://cran.us.r-project.org")
# install.packages('lme4', repos = "http://cran.us.r-project.org")
# install.packages('lmerTest', repos = "http://cran.us.r-project.org")
# install.packages('tidyboot', repos = "http://cran.us.r-project.org")
# install.packages('here', repos = "http://cran.us.r-project.org")
# install.packages('ggridges', repos = "http://cran.us.r-project.org")
# install.packages('cowplot', repos = "http://cran.us.r-project.org")
# install.packages('tidyverse', repos = "http://cran.us.r-project.org")

library(tidyverse)
library(ggthemes)
library(lme4)
library(lmerTest)
library(tidyboot)
library(here)
library(ggridges)
library(cowplot)

d <- read_csv(here('nocode/bar.csv'))  %>%
  mutate(mode = fct_recode(mode, A = 'a', 
                                 B = 'b',
                                 C = 'c',
                                 D = 'd'))

d %>%
  group_by(chain_seed, mode) %>%
  tally()

d.wide <- d %>%
  select(chain_seed, mode, sat_items_n) %>%
  pivot_wider(names_from = mode, values_from = sat_items_n)
t.test(d.wide$A, d.wide$B, paired = T)
t.test(d.wide$A, d.wide$C, paired = T)
t.test(d.wide$A, d.wide$D, paired = T)
t.test(d.wide$B, d.wide$C, paired = T)
t.test(d.wide$B, d.wide$D, paired = T)
t.test(d.wide$C, d.wide$D, paired = T)
t.test(d.wide$NP, d.wide$DP, paired = T)
t.test(d.wide$NP, d.wide$DS, paired = T)

bars.bootstrapped <- d %>%
  group_by(mode) %>%
  tidyboot_mean(sat_items_n, nboot = 1000)


bars.plot <- bars.bootstrapped %>%  
  ggplot(aes(x = mode, y = empirical_stat, color = mode, fill = mode)) +
    geom_bar(stat = 'identity', alpha = .5,width = 0.5) +
    geom_errorbar(aes(ymin = ci_lower, ymax = ci_upper), width= 0.3, size=2.0) +
    scale_y_continuous(breaks = seq(-1, 2, 0.2)) +
    scale_x_discrete(guide = guide_axis(n.dodge = 1))+
    scale_color_colorblind() +
    scale_fill_colorblind() +
    labs(x = 'System', y = 'Solving rate') +
    theme(text = element_text(size = 10), aspect.ratio = 1, legend.position = 'none')


bars.bootstrapped

d.hello <- read_csv('nocode/time_bin.csv')

times.plot <- d.hello %>%
  group_by(n_utter, pair) %>%
  tidyboot_mean(success_rate, nboot = 1000) %>%
  ggplot(aes(x = n_utter, y = empirical_stat, color = pair)) +
    geom_line(aes(group = pair), alpha = 0.5, linewidth = 2, size=1) +
    geom_errorbar(aes(ymin = ci_lower, ymax = ci_upper), width = 0.05, color = 'black', position=position_dodge(1)) +
    scale_x_continuous(breaks = seq(0, 3000, 500)) +
    labs(x = "Time", y = "Solving rate") +
    theme(text = element_text(size = 10), legend.title=element_blank(), legend.key.height = unit(4, "pt"), legend.position=c(0.82,0.13), legend.background=element_rect(fill="transparent")) + 
    scale_color_manual(values = c("#0072B2", "#D55E00"),
                       limits = c("System A", "System B"))

d.hello <- read_csv('nocode/interaction_bin.csv')
  # 
interaction.plot <- d.hello %>%
  group_by(n_utter, pair) %>%
  tidyboot_mean(success_rate, nboot = 1000) %>%
  ggplot(aes(x = n_utter, y = empirical_stat, color = pair)) +
    geom_line(aes(group = pair), alpha = 0.5, linewidth = 2, size=1) +
    geom_errorbar(aes(ymin = ci_lower, ymax = ci_upper), width = 0.05, color = 'black', position=position_dodge(1)) +
    scale_x_continuous(breaks = seq(0, 45, 10)) +
    labs(x = "Number of Interactions", y = "Solving rate") +
    theme(text = element_text(size = 10), legend.title=element_blank(), legend.key.height = unit(4, "pt"), legend.position=c(0.82,0.13), legend.background=element_rect(fill="transparent")) + 
    scale_color_manual(values = c("#0072B2", "#D55E00", "#75c4af"),
                       limits = c("System A", "System B", "System A(TC)"))


plot_grid(bars.plot, times.plot, interaction.plot, ncol = 3, rel_widths = c(1,1,1),
          align = 'v', axis = 't',
          labels = c('A', 'B ', 'C '), label_size = 10) %>%
  plot_grid(legend, ., ncol = 1, rel_heights = c(.1, 1))

ggsave('nocode.pdf', height = 3, width = 10)
ggsave('nocode.png', height = 3, width = 10)


