import unittest
from anpl.parser import ANPLParser
from anpl.synthesizer import fun_synthesis, batch_fun_synthesis

class TestSynthesizing(unittest.TestCase):

    def setUp(self) -> None:
        self.parser = ANPLParser()

    def test_fun_synthesis(self):
        source_code = """
def hello(x, y):
    "compute the sum of x, y"

def main(a, b):
    return hello(a, b) + 3
"""
        source_code = """
def main(lst: list[int]):
    return `get the max element of the list`(lst)
"""
        anpl = self.parser.parse(source_code)
        res = fun_synthesis(anpl, "_hole0")
        print(res)        

    def test_batch_fun_synthesis(self):
        source_code = """
def main(lst: list[int]):
    return `get the max element of the list`(lst)
"""
        anpl = self.parser.parse(source_code)
        reses = batch_fun_synthesis(anpl, "_hole0", n=3, temp=0.2)
        for res in reses:
            print(res)