import numpy as np
def main(input_grid):
    # Split the input grid into top and bottom grids
    top_grid = input_grid[:4,:]
    bottom_grid = input_grid[4:,:]
    # Find the intersection of black pixels in the top and bottom grids
    black_pixels_top = np.where(top_grid == 0, 1, 0)
    black_pixels_bottom = np.where(bottom_grid == 0, 1, 0)
    intersection = np.multiply(black_pixels_top, black_pixels_bottom)
    # Create the output grid with red intersection pixels and black non-intersection pixels
    output_grid = np.where(intersection == 1, 2, 0)
    return output_grid
