import numpy as np
black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)
def main(input_grid: np.ndarray) -> np.ndarray:
    # Create a copy of the input grid to modify
    output_grid = input_grid.copy()
    # Find the locations of all red pixels and draw red vertical lines
    red_pixels = np.where(input_grid == red)
    for x, y in zip(red_pixels[0], red_pixels[1]):
        output_grid[:, y] = red
    # Find the locations of green pixels and draw horizontal green lines
    green_pixels = np.where(input_grid == green)
    for x, y in zip(green_pixels[0], green_pixels[1]):
        output_grid[x, :] = green
    # Find the locations of blue pixels and draw blue horizontal lines
    blue_pixels = np.where(input_grid == blue)
    for x, y in zip(blue_pixels[0], blue_pixels[1]):
        output_grid[x, :] = blue
    return output_grid
