import numpy as np
black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)
def main(input_grid: np.ndarray) -> np.ndarray:
    # Find the xmin, xmax, ymin, ymax of all green coordinates
    green_coords = np.argwhere(input_grid == green)
    xmin, ymin = np.min(green_coords, axis=0)
    xmax, ymax = np.max(green_coords, axis=0)
    # Compute the length
    length = int((xmax - xmin + 1) / 2)
    # Loop through the points and change the color if necessary
    for i in range(length):
        for j in range(length):
            if (xmax + 1 + i < input_grid.shape[0]) and (ymax + 1 + j < input_grid.shape[1]):
                input_grid[xmax + 1 + i, ymax + 1 + j] = teal
            if (xmin - 1 - i >= 0) and (ymin - 1 - j >= 0):
                input_grid[xmin - 1 - i, ymin - 1 - j] = teal
    return input_grid
