import numpy as np

# Define color codes
black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Find the least common color in the input grid
    color_counts = np.bincount(input_grid.flatten())
    existing_colors = np.nonzero(color_counts)[0]
    least_common_color = np.argmin(color_counts[existing_colors])

    # Find the sub grid that contains the least common color
    rows, cols = np.where(input_grid == existing_colors[least_common_color])
    min_row, max_row = np.min(rows), np.max(rows)
    min_col, max_col = np.min(cols), np.max(cols)
    output_grid = input_grid[min_row:max_row+1, min_col:max_col+1]

    return output_grid
    