import numpy as np
# Define color constants
(black, blue, red, green, yellow, grey, pink, orange, teal, maroon) = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
  # Find coordinates of gray pixel
  gray_coords = np.argwhere(input_grid == grey)[0]
  x, y = gray_coords[0], gray_coords[1]
  # Get 3x3 area below gray pixel
  area = input_grid[x+1:x+4, y-1:y+2]
  return area
