import numpy as np
black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)
def main(input_grid: np.ndarray) -> np.ndarray:
  # Count the frequency of each color in the input grid
  color_counts = np.bincount(input_grid.flatten())
  # Get the indices of the third, fourth, and fifth most frequent colors
  third_most_frequent = np.argsort(color_counts)[-3]
  fourth_most_frequent = np.argsort(color_counts)[-4]
  fifth_most_frequent = np.argsort(color_counts)[-5]
  # Create the output grid with the third, fourth, and fifth most frequent colors
  output_grid = np.array([[third_most_frequent], [fourth_most_frequent], [fifth_most_frequent]])
  return output_grid
