import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Find the index and length of the red line
    red_line_indices = np.where(input_grid == red)
    red_line_index, red_line_length = red_line_indices[0][0], len(red_line_indices[1])
    
    # Color rows above the red line in green
    for i in range(red_line_index):
        length = red_line_length + (red_line_index - i)
        if length == 0:
            break
        input_grid[i, :length] = green
        input_grid[i, length:] = black
    
    # Color rows below the red line in blue
    for i in range(red_line_index+1, input_grid.shape[0]):
        length = red_line_length - (i - red_line_index)
        if length == 0:
            break
        input_grid[i, :length] = blue
        input_grid[i, length:] = black
    
    return input_grid