import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Step 1: Find the largest consecutive color count across all rows
    tcolor = None
    tcnt = 0
    for row in input_grid:
        color_count = 1
        for i in range(1, len(row)):
            if row[i] == row[i-1]:
                color_count += 1
            else:
                if color_count > tcnt:
                    tcnt = color_count
                    tcolor = row[i-1]
                color_count = 1
        if color_count > tcnt:
            tcnt = color_count
            tcolor = row[-1]

    # Step 2: Find the coordinates of the pixel to the right and below the pixel if they are both tcolor
    lux = None
    luy = None
    for i in range(len(input_grid)):
        for j in range(len(input_grid[0])):
            if input_grid[i][j] == tcolor:
                if j+1 < len(input_grid[0]) and input_grid[i][j+1] == tcolor:
                    if i+1 < len(input_grid) and input_grid[i+1][j] == tcolor:
                        lux = j
                        luy = i
                        break
        if lux is not None:
            break

    # Step 3: Find the coordinates of the pixel to the right and upper the pixel if they are both tcolor
    lbx = None
    lby = None
    for i in range(len(input_grid)-1, -1, -1):
        for j in range(len(input_grid[0])):
            if input_grid[i][j] == tcolor:
                if j+1 < len(input_grid[0]) and input_grid[i][j+1] == tcolor:
                    if i-1 >= 0 and input_grid[i-1][j] == tcolor:
                        lbx = j
                        lby = i
                        break
        if lbx is not None:
            break

    # Step 4: Take the subgrid and return it
    subgrid = input_grid[luy+1:lby, lux+1:lux+tcnt-1]
    return subgrid
    