import numpy as np
black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def most_common_number(arr: np.ndarray) -> int:
    # Flatten the array to 1D
    flat_arr = arr.flatten()

    # Get the counts of each number
    counts = np.bincount(flat_arr)

    # Find the index of the most common number
    most_common_index = np.argmax(counts)

    return most_common_index

def main(input_grid: np.ndarray) -> np.ndarray:
    # Get the color which occupies the fewest location in the input
    color_counts = {}
    for row in input_grid:
        for color in row:
            if color in color_counts:
                color_counts[color] += 1
            else:
                color_counts[color] = 1
    min_color = min(color_counts, key=color_counts.get)

    # Get all positions which is the color
    color_positions = np.argwhere(input_grid == min_color)

    # Collect the four neighborhoods to each location to a list
    neighborhoods = []
    for pos in color_positions:
        row, col = pos
        neighbors = []
        if row > 0:
            neighbors.append(input_grid[row-1, col])
        if row < input_grid.shape[0]-1:
            neighbors.append(input_grid[row+1, col])
        if col > 0:
            neighbors.append(input_grid[row, col-1])
        if col < input_grid.shape[1]-1:
            neighbors.append(input_grid[row, col+1])
        neighborhoods.append(neighbors)
    return np.array([[most_common_number(np.array(neighborhoods))]], dtype=np.int32)