import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)


def main(input_grid):
    # Find all colors in the input except black
    colors = set(np.unique(input_grid)) - {black}

    # Sort colors according to the number of positions with this color
    sorted_colors = sorted(colors, key=lambda c: np.count_nonzero(input_grid == c), reverse=True)
    output = np.array([sorted_colors], dtype=np.int32)
    return output.T