import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Find the color of the lines
    line_color = None
    for color in range(10):
        for i in range(input_grid.shape[0]):
            if np.all(input_grid[i] == color):
                line_color = color
                break
        if line_color is not None:
            break
        for j in range(input_grid.shape[1]):
            if np.all(input_grid[:,j] == color):
                line_color = color
                break
        if line_color is not None:
            break
    
    # Create a copy of the input grid
    output_grid = np.copy(input_grid)
    
    # Find all pixels in colors other than black and the line color
    for color in range(10):
        if color != black and color != line_color:
            pixels = np.argwhere(input_grid == color)
            for i in range(pixels.shape[0]):
                for j in range(i+1, pixels.shape[0]):
                    if pixels[i][0] == pixels[j][0]:
                        start_col = pixels[i][1] + 1
                        end_col = pixels[j][1]
                        if start_col < end_col:
                            output_grid[pixels[i][0], start_col:end_col][input_grid[pixels[i][0], start_col:end_col] == black] = color
                        elif start_col > end_col:
                            output_grid[pixels[i][0], end_col:start_col][input_grid[pixels[i][0], end_col:start_col] == black] = color
                    elif pixels[i][1] == pixels[j][1]:
                        start_row = pixels[i][0] + 1
                        end_row = pixels[j][0]
                        if start_row < end_row:
                            output_grid[start_row:end_row, pixels[i][1]][input_grid[start_row:end_row, pixels[i][1]] == black] = color
                        elif start_row > end_row:
                            output_grid[end_row:start_row, pixels[i][1]][input_grid[end_row:start_row, pixels[i][1]] == black] = color
    
    return output_grid