import numpy as np

black, blue, red, green, yellow, grey, pink, orange, teal, maroon = range(10)

def main(input_grid: np.ndarray) -> np.ndarray:
    # Get the dimensions of the input grid
    rows, cols = input_grid.shape

    # Traverse each column and count how many red pixels are in each column
    for j in range(cols):
        cnt = 0
        for i in range(rows):
            if input_grid[i][j] == red:
                cnt += 1

        # Divide the number of red pixels by 2 and denote it as cnt
        cnt = cnt // 2

        # Change the cnt pixels at the bottom of the column to teal
        for i in range(rows-1, rows-1-cnt, -1):
            input_grid[i][j] = teal

    # Return the modified grid
    return input_grid